
%%Parametros iniciales%%

N1 = 1;  % El cuerpo central tiene (dos) una masas solares.
N2 = 3*(10^-6);
a=N2/N1;
pL1=[1-((a/3)^(1/3)) 0];
pL2=[1+((a/3)^(1/3)) 0];
pL3=[-1-((5*a)/12) 0];
pL4=[(1/2)*((N1-N2)/(N1+N2)) sqrt(3)/2];
vL1=[0 29.78];
vL2=vL1;
vL3=[0 -29.78];
vL4=[(29.78/(sqrt(3+((N1-N2)/(N1+N2))^2))*(-sqrt(3))) (29.78/(sqrt(3+((N1-N2)/(N1+N2))^2))*((N1-N2)/(N1+N2)))];
r0=[1 0]; % El planeta est inicialmente a una U.A. de la estrella
r3=pL4;%Posicin satelite
v0=[0 29.78];  % Su velocidad inicial son 25 km/s
v3=vL4;    %Veloc. inicial satelite
s0 = [r0 v0 r3 v3];   % Vector con las condiciones iniciales
tspan = [0 1];   % Una rbita del planeta son aproximadamente 0.35 aos
xs=0;   % Posicin X de la estrella
ys=0;   % Posicin Y de la estrella
%fun1 = @(t,s) Problema2C(t,s,N1);
% Creo un vector de estructuras con los diferentes valores
% de los parmetros que controlan la precisin.
%fun2 = @(t,s3) Problema3C(t,s0,s3,N1,N2);
fun2 = @(t,s) Problema3C(t,s,N1,N2);
%OrbitaCompleta = @(x,y) CoordenadaY(x,y);
%OrbitaCompleta3= @(x3,y3) CoordenadaY3(x3,y3);

%options(3) = odeset('RelTol',1e-9,'AbsTol',1e-9,'Events',OrbitaCompleta);

%options3(3) = odeset('RelTol',1e-9,'AbsTol',1e-9,'Events',OrbitaCompleta3);

options = odeset('RelTol',1e-12,'AbsTol',1e-12);

%tabla45 = zeros(4,1);   % Aqu guardaremos los resultados para ode45
%tabla113 = zeros(4,1);  % Aqu guardaremos los resultados para ode113
%tabla453 = zeros(4,1);
%tabla1133 = zeros(4,1);
%%Resolucion del problema para distintas tolerancias%%

%%%Orbita del planeta%%%
% Solucin usando ODE45
%    sol45=ode45(fun1,tspan,s0,options(3));
%    t45=sol45.x;
%    x45=sol45.y(1,:);
%    y45=sol45.y(2,:);
%    vx45=sol45.y(3,:);
%    vy45=sol45.y(4,:);
% Integrales de movimiento usando la solucin de ODE45
%    r = [x45 ; y45];
%    v = [vx45 ; vy45];
%    [E45 L45]=IntegralesProblema2C(r,v,N1);
% Solucin usando ODE113
tspan = 0:0.05:0.5;
    [t solucion] =ode113(fun2,tspan,s0,options);
    xp=solucion(:,1);
    yp=solucion(:,2);
    vxp=solucion(:,3);
    vyp=solucion(:,4);
    xsat=solucion(:,5);
    ysat=solucion(:,6);
    vxsat=solucion(:,7);
    vysat=solucion(:,8);

% Integrales de movimiento usando la solucin de ODE113
%    r = [x113 ; y113];
%    v = [vx113 ; vy113];
%    [E113 L113]=IntegralesProblema2C(r,v,N1);
% Calculamos los valores que hemos de tabular.
%    tabla45(1,1) = sol45.stats.nfevals;                 % No. de evaluaciones de las derivadas
%    tabla45(2,1) = abs(max(E45)-min(E45))/abs(E45(1));  % Variacin relativa de la energa
%    tabla45(3,1) = abs(max(L45)-min(L45))/abs(L45(1));  % Variacin relativa del momento angular
%    tabla45(4,1) = sol45.x(length(sol45.x));            % Perodo orbital
%    tabla113(1,1) = sol113.stats.nfevals;
%    tabla113(2,1) = abs(max(E113)-min(E113))/abs(E113(1));
%    tabla113(3,1) = abs(max(L113)-min(L113))/abs(L113(1));
%    tabla113(4,1) = sol113.x(length(sol113.x));
    
 %%%Orbita para el satelite%%%
 
% Representamos las soluciones

    
    figure(1)
    hold on
    plot(xs,ys,'ok','MarkerFaceColor','k');
    plot(xsat,ysat,'g+-');  %%Orbita satelite
    plot(xp,yp,'b*-');  %%Orbita satelite
    xlabel('x (U.A.)');
    ylabel('y (U.A.)');
    legend('Estrella','Satlite','Planeta','Location','SouthWest');
    titulo = 'rbita del planeta y el satlite';
    title(titulo);
    axis equal;
    hold off




